import os
import configparser
import json
from tqdm import tqdm

from utils.logger import Logger
from llm.llm_wrapper import LLMWrapper
from llm.auxiliary import Auxiliary
from llm.llm_const import (
    MODEL_ID_SILICONFLOW_DEEPSEEK_V3,
    MODEL_ID_SILICONFLOW_QWEN3_14B,
    MODEL_ID_GITEE_QWEN3_32B,
    MODEL_ID_CLAUDE_SONNET_4,
    MODEL_ID_SILICONFLOW_BGE_M3,
    MODEL_ID_LLAMA3_8B,
)

import torch
import sys

print(f"Python version: {sys.version}")
print(f"PyTorch version: {torch.__version__}")
print(f"CUDA available: {torch.cuda.is_available()}")
print(f"CUDA version: {torch.version.cuda}")
if torch.cuda.is_available():
    print(f"CUDA device count: {torch.cuda.device_count()}")
    print(f"Current CUDA device: {torch.cuda.current_device()}")
    print(f"CUDA device name: {torch.cuda.get_device_name(0)}")


project_root = os.path.dirname(__file__)
logger = Logger(__name__, 'dev')

def read_config(local_config_path, default_config_path):
    config = configparser.ConfigParser()

    if os.path.exists(local_config_path):
        config.read(local_config_path)
        print(f'Loaded configuration from {local_config_path}')
    else:
        config.read(default_config_path)
        print(f'Loaded configuration from {default_config_path}')

    return config

test_config = read_config(
    os.path.join(project_root, 'local_config.ini'),
    os.path.join(project_root, 'default_config.ini'),
)

def _init_llm(model_id, api_key, model_save_path=None, model_cache_path=None, token=None):
    llm_config = {
        'model_id': model_id,
        'model_save_path': model_save_path,
        'model_cache_path': model_cache_path,
        'api_key': api_key,
        'token': token,
    }
    return LLMWrapper(config=llm_config, logger=logger)

huggingface_cache_dir = test_config.get('BASE', 'huggingface-cache')
huggingface_save_dir = test_config.get('BASE', 'huggingface-save')
huggingface_token = test_config.get('API_KEY', 'huggingface')
siliconflow_api_key = test_config.get('API_KEY', 'siliconflow')
claude_api_key = test_config.get('API_KEY', 'claude')

model_save_path = os.path.join(huggingface_save_dir, 'model')
model_cache_path = os.path.join(huggingface_cache_dir, 'model')

model_id = MODEL_ID_LLAMA3_8B
model_api_key = None
token = huggingface_token

llm = _init_llm(
    model_id,
    model_api_key,
    model_save_path,
    model_cache_path,
    token,
)
llm.init()
response = llm.talk("who r u?")
print(response)